### 55.1. 使用CLI运行应用

你可以使用`run`命令编译和运行Groovy源代码。Spring Boot CLI完全自包含，以致于你不需要安装任何外部的Groovy。

下面是一个使用Groovy编写的"hello world" web应用：
hello.grooy
```java
@RestController
class WebApplication {

    @RequestMapping("/")
    String home() {
        "Hello World!"
    }

}
```
想要编译和运行应用，输入：
```shell
$ spring run hello.groovy
```
想要给应用传递命令行参数，你需要使用一个`--`来将它们和"spring"命令参数区分开来。例如：
```shell
$ spring run hello.groovy -- --server.port=9000
```
想要设置JVM命令行参数，你可以使用`JAVA_OPTS`环境变量，例如：
```shell
$ JAVA_OPTS=-Xmx1024m spring run hello.groovy
```
